/*
 * EXPORT CONTROLLED - This technology or software is subject to the U.S. Export
 * Administration Regulations (EAR), (15 C.F.R. Parts 730-774). No authorization
 * from the U.S. Department of Commerce is required for export, re-export, in-
 * country transfer, or access EXCEPT to country group E:1 or E:2 countries/
 * persons per Supp. 1 to Part 740 of the EAR.
*/

/*
 * Copyright © 2011,2021 Liquid Robotics, Inc., confidential and
 * proprietary. All rights reserved.
 */

package com.liquidr.dataservice;

import java.text.SimpleDateFormat;
import java.util.concurrent.TimeUnit;
import java.util.Date;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.XMLGregorianCalendar;

/**
 *
 * @author: Theja Kanumury
 * @email: theja.kanumury@liquid-robotics.com
 * @Version: 1.1.0
 * 
 */
public class DataService {
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {
        // Constants
        String token = "XXXXX";                             // WGMS Data Service Access Token
        int resultFormat = 1;                               // Default option
        String reportName = "Raw Data Report";              // Data to be sent back
        String[] vehicles = {"491970459", "1970602397"};    // Serial number of vehicles
        String date1 = "2020-10-26T03:00:00Z";              // Start date and time of the requested data.
        String date2 = "2020-10-26T03:05:00Z";              // End date and time of the requested data.
        int interval = 2;                                   // Length of time interval in minutes.
        int period = 10;                                    // Length of time you want the java program to run in minutes.
        
        systemCheck();
//        getReportList(token, resultFormat);
//        getGliderList(token, resultFormat);
//        getReportData(token, resultFormat, reportName, vehicles, date1, date2);
//        getPeriodicData(token, resultFormat, reportName, vehicles, interval, period);
    }
    
    public static WGMSDataSoap callDataService() {
        try { // Call Web Service Operation
            WGMSData service = new WGMSData();
            WGMSDataSoap port = service.getWGMSDataSoap();
            return port;
        } catch (Exception e) {
            // TODO handle custom exceptions here
            e.printStackTrace();
            return null;
        }
    }
    
    // Method to check if Data Service is up.
    public static void systemCheck() {
        WGMSDataSoap client = callDataService();
        System.out.println(client.systemCheck());
//        return client.systemCheck();
    }
    
    // Method to get list of reports that can be requested.
    public static void getReportList(String token, int resultFormat) {
        WGMSDataSoap client = callDataService();
        System.out.println(client.getReportList(token, resultFormat));
//        return client.getReportList(token, resultFormat);
    }
    
    // Method to get list of gliders in specified org.
    public static void getGliderList(String token, int resultFormat) {
        WGMSDataSoap client = callDataService();
        System.out.println(client.getGliderList(token, resultFormat));
//        return client.getGliderList(token, resultFormat);
    }
    
    // Function to get data from specified vehicles within a specified time frame.
    public static void getReportData(String token, int resultFormat, String reportName, String[] vehicles, String date1, String date2) {
        WGMSDataSoap client = callDataService();
        XMLGregorianCalendar startDate = null;
        XMLGregorianCalendar endDate = null;
        
        try {
            startDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(date1);
            endDate = DatatypeFactory.newInstance().newXMLGregorianCalendar(date2);
        } catch (DatatypeConfigurationException e) {
            e.printStackTrace();
        }
        for (String serialNo : vehicles) {
            System.out.println(client.getReportData(token, reportName, serialNo, startDate, endDate, resultFormat));
//            return client.getReportData(token, reportName, serialNo, startDate, endDate, resultFormat);
        }
    }
    
    // Method to get data at specified intervals of time.
    public static void getPeriodicData(String token, int resultFormat, String reportName, String[] vehicles, int interval, int period) {
        Date startTime = new Date(System.currentTimeMillis());
        System.out.println("Started requesting data from " + startTime + " at an interval of " + String.valueOf(interval) + " minute(s) for " + String.valueOf(period) + " minutes.");
        // Loop to request data during the specified length of time.
        while (true) {
            // Making a call to get the last interval of data
            Date now = new Date(System.currentTimeMillis());
            Date intervalTimeAgo = new Date(System.currentTimeMillis() - (interval * 60 * 1000));
            String startDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(intervalTimeAgo);
            String endDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").format(now);
            System.out.println("Getting data between " + startDate + " & " + endDate);
            getReportData(token, resultFormat, reportName, vehicles, startDate, endDate);
            // Checking if we're past the specified period
            Date timeCheck = new Date(System.currentTimeMillis());
            int timeElapsed = (int)(timeCheck.getTime() - startTime.getTime()) / (60 * 1000);
            if (timeElapsed >= period) {
                break;
            } else {
               // Calculating how many seconds program has drifted from startTime
               Date driftCheck = new Date(System.currentTimeMillis());
               long driftTime = ((driftCheck.getTime() - startTime.getTime()) / (1000));
               // Updating how long program sleeps based on drift
               int sleepTime = (interval * 60) - (int)(driftTime % 60);
               try {
                TimeUnit.SECONDS.sleep(sleepTime);
               } catch (Exception e) {
                   e.printStackTrace();
               }
            }
        }
    }
    
}
